---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-Term Vectors

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **レスポンスのterm_vectors詳細構造**：根拠不足（レスポンスクラスの内部構造を完全に追跡していない）

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/termvectors.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/document/RestTermVectorsAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのルート定義（GET/POST x 2パス） | E-01, E-02 (行65-73) | ○ |
| C-02 | term_statisticsのデフォルトfalse | E-01 (default: false) | ○ |
| C-03 | field_statisticsのデフォルトtrue | E-01 (default: true) | ○ |
| C-04 | offsets, positions, payloadsのデフォルトtrue | E-01 | ○ |
| C-05 | TermVectorsRequest(index, id)のコンストラクタ | E-02 (行83) | ○ |
| C-06 | parseRequestによるボディパース | E-02 (行84-88) | ○ |
| C-07 | readURIParametersのstatic実装 | E-02 (行94-108) | ○ |
| C-08 | キャメルケース・スネークケース両対応 | E-02 (行105-108) | ○ |
| C-09 | addFieldStringsFromParameterの実装 | E-02 (行111-128) | ○ |
| C-10 | version_typeのenum選択肢 | E-01 (options: internal/external/external_gte/force) | ○ |
| C-11 | ボディが任意（required: false） | E-01 (body.required: false) | ○ |
| C-12 | 関連機能No.30（TermVectors API） | E-04 | ○ |
| C-13 | VersionTypeの設定処理 | E-02 (行103) | ○ |
| C-14 | preference パラメータの設定 | E-02 (行104) | ○ |
| C-15 | RestToXContentListenerによるレスポンスハンドリング | E-02 (行91) | ○ |
| C-16 | レスポンスのterm_vectors詳細構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンスの詳細構造はTermVectorsResponse.toXContent()の実装に依存
  - 候補：TermVectorsResponse.java / TermVectorsFields.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義とRESTハンドラの整合性は高い
- 1: 中リスク - レスポンス構造の詳細は追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] C-16: TermVectorsResponseの実際のJSON出力構造を確認
- [ ] filter パラメータ（ボディ）の具体的なフィルタリング条件を確認
- [ ] 人工ドキュメント使用時の動作を実際に確認
